import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [payments] = await db.query('SELECT * FROM studentPayments ORDER BY period DESC, startDate DESC');
    return json({ success: true, data: payments });
  } catch (error) {
    console.error('Get payments error:', error);
    return json({ error: 'Gagal mengambil data pembayaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { studentId, period, billType, startDate, endDate, status, amount, discount, fine, paidDate } = data;

    if (!studentId || !period || !billType || !startDate) {
      return json({ error: 'ID Siswa, Periode, Jenis Tagihan, dan Tanggal Mulai wajib diisi' }, { status: 400 });
    }

    // Hitung total
    const total = (amount || 0) - (discount || 0) + (fine || 0);

    const [result] = await db.query(
      `INSERT INTO studentPayments (studentId, period, billType, startDate, endDate, status, amount, discount, fine, total, paidDate)
       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        studentId,
        period.trim(),
        billType.trim(),
        startDate,
        endDate || null,
        status || 'BB',
        amount || 0,
        discount || 0,
        fine || 0,
        total,
        paidDate || null
      ]
    );

    return json({
      success: true,
      message: 'Data pembayaran berhasil ditambahkan',
      data: { id: result.insertId, ...data, total }
    });
  } catch (error) {
    console.error('Create payment error:', error);
    return json({ error: 'Gagal menambahkan data pembayaran' }, { status: 500 });
  }
}
