import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET() {
  try {
    const [grades] = await db.query('SELECT * FROM grades ORDER BY year DESC, semester DESC, class, studentName');
    return json({ success: true, data: grades });
  } catch (error) {
    console.error('Get grades error:', error);
    return json({ error: 'Gagal mengambil data nilai' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function POST({ request }) {
  try {
    const data = await request.json();
    const { studentId, studentName, subject, teacher, class: className, dailyGrade, midtermGrade, finalGrade, attitudeGrade, semester, year } = data;

    if (!studentId || !subject) {
      return json({ error: 'ID Siswa dan Mata Pelajaran wajib diisi' }, { status: 400 });
    }

    // Hitung rata-rata
    let average = null;
    if (dailyGrade !== null && dailyGrade !== undefined && midtermGrade !== null && midtermGrade !== undefined && finalGrade !== null && finalGrade !== undefined) {
      average = ((dailyGrade * 0.3) + (midtermGrade * 0.3) + (finalGrade * 0.4)).toFixed(2);
    }

    const [result] = await db.query(
      `INSERT INTO grades (studentId, studentName, subject, teacher, class, dailyGrade, midtermGrade, finalGrade, attitudeGrade, average, semester, year)
       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
      [
        studentId,
        studentName || null,
        subject.trim(),
        teacher || null,
        className || null,
        dailyGrade || null,
        midtermGrade || null,
        finalGrade || null,
        attitudeGrade || null,
        average,
        semester || null,
        year || null
      ]
    );

    return json({
      success: true,
      message: 'Nilai berhasil ditambahkan',
      data: { id: result.insertId, ...data, average }
    });
  } catch (error) {
    console.error('Create grade error:', error);
    return json({ error: 'Gagal menambahkan nilai' }, { status: 500 });
  }
}
