import 'dotenv/config';
import mysql from 'mysql2/promise';

// Production: pakai env (DB_HOST, DB_USER, DB_PASSWORD, DB_NAME, DB_PORT). Jangan hardcode.
export const db = mysql.createPool({
  host: process.env.DB_HOST || '127.0.0.1',
  user: process.env.DB_USER || 'root',
  password: process.env.DB_PASSWORD ?? '',
  database: process.env.DB_NAME || 'profile_sekolah',
  port: parseInt(process.env.DB_PORT || '3306', 10),
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
});
