import { json } from '@sveltejs/kit';
import jwt from 'jsonwebtoken';

const JWT_SECRET = process.env.JWT_SECRET || process.env.SESSION_SECRET || 'siakad-dev-secret-ganti-di-production';
const COOKIE_NAME = 'siakad_token';

/** @type {import('@sveltejs/kit').Handle} */
export async function handle({ event, resolve }) {
  // Route yang tidak perlu auth
  const pathname = event.url.pathname;
  if (pathname === '/api/login' || pathname === '/api/register' || pathname === '/api/logout' || pathname.startsWith('/api/test-student')) {
    return resolve(event);
  }

  // Semua route /api/* lain wajib auth
  if (pathname.startsWith('/api/')) {
    const token = event.cookies.get(COOKIE_NAME) || event.request.headers.get('Authorization')?.replace(/^Bearer\s+/i, '');

    if (!token) {
      return json({ error: 'Unauthorized', success: false }, { status: 401 });
    }

    let payload;
    try {
      payload = jwt.verify(token, JWT_SECRET);
    } catch (err) {
      return json({ error: 'Token tidak valid atau kedaluwarsa', success: false }, { status: 401 });
    }

    const userId = payload.userId ?? payload.sub;
    const role = payload.role;
    if (!userId || !role) {
      return json({ error: 'Token tidak valid', success: false }, { status: 401 });
    }

    event.locals.user = { id: Number(userId), role };

    // /api/admin/* : GET = admin atau guru, selain GET = hanya admin
    if (pathname.startsWith('/api/admin/')) {
      const method = event.request.method.toUpperCase();
      if (method !== 'GET') {
        if (role !== 'admin') {
          return json({ error: 'Forbidden: hanya admin', success: false }, { status: 403 });
        }
      } else {
        if (role !== 'admin' && role !== 'guru') {
          return json({ error: 'Forbidden: akses admin/guru saja', success: false }, { status: 403 });
        }
      }
    }

    // /api/users/[id] : hanya diri sendiri atau admin
    const usersMatch = pathname.match(/^\/api\/users\/(\d+)\/?$/);
    if (usersMatch) {
      const requestedId = parseInt(usersMatch[1], 10);
      if (event.locals.user.id !== requestedId && role !== 'admin') {
        return json({ error: 'Forbidden: akses data user lain', success: false }, { status: 403 });
      }
    }
  }

  return resolve(event);
}
